/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class TextUtilities {
    private static JComponent getJComponent(View view) {
        Container component;
        if (view != null && (component = view.getContainer()) instanceof JComponent) {
            return (JComponent)component;
        }
        return null;
    }

    public static int drawTabbedText(View view, Segment s, int x, int y, Graphics g, TabExpander e, int startOffset) {
        JComponent component = TextUtilities.getJComponent(view);
        FontMetrics metrics = g.getFontMetrics();
        int nextX = x;
        char[] txt = s.array;
        int txtOffset = s.offset;
        int flushLen = 0;
        int flushIndex = s.offset;
        int spaceAddon = 0;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        int n = s.offset + s.count;
        for (int i = txtOffset; i < n; ++i) {
            if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                if (flushLen > 0) {
                    nextX = TextUtilities.drawChars(component, g, txt, flushIndex, flushLen, x, y);
                    flushLen = 0;
                }
                flushIndex = i + 1;
                if (txt[i] == '\t') {
                    nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += metrics.charWidth(' '));
                } else if (txt[i] == ' ') {
                    nextX += metrics.charWidth(' ') + spaceAddon;
                    if (i <= spaceAddonLeftoverEnd) {
                        // empty if block
                    }
                }
                x = ++nextX;
                continue;
            }
            if (txt[i] == '\n' || txt[i] == '\r') {
                if (flushLen > 0) {
                    nextX = TextUtilities.drawChars(component, g, txt, flushIndex, flushLen, x, y);
                    flushLen = 0;
                }
                flushIndex = i + 1;
                x = nextX;
                continue;
            }
            ++flushLen;
        }
        if (flushLen > 0) {
            nextX = TextUtilities.drawChars(component, g, txt, flushIndex, flushLen, x, y);
        }
        return nextX;
    }

    public static int drawChars(JComponent c, Graphics g, char[] data, int offset, int length, int x, int y) {
        if (length <= 0) {
            return x;
        }
        FontMetrics fm = g.getFontMetrics();
        int nextX = x + g.getFontMetrics().charsWidth(data, offset, length);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.attachText(c, new Rectangle(x, y - fm.getAscent(), nextX - x, fm.getHeight()), new String(data, offset, length), -1, g.getFont(), g.getColor(), null);
        return nextX;
    }

    public static int drawSelectedText(Graphics g, View view, TabExpander tabExpander, int x, int y, int p0, int p1) throws BadLocationException {
        JTextComponent host = (JTextComponent)view.getContainer();
        Highlighter h = host.getHighlighter();
        g.setFont(host.getFont());
        Caret c = host.getCaret();
        ComponentState hostState = host.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(host, hostState);
        Color color = theme.getForegroundColor();
        if (c.isSelectionVisible() && h != null) {
            color = theme.getSelectionForegroundColor();
        }
        g.setColor(color);
        Document doc = view.getDocument();
        Segment s = new Segment();
        doc.getText(p0, p1 - p0, s);
        int ret = TextUtilities.drawTabbedText(view, s, x, y, g, tabExpander, p0);
        return ret;
    }

    public static int drawUnselectedText(Graphics g, View view, TabExpander tabExpander, int x, int y, int p0, int p1) throws BadLocationException {
        JTextComponent host = (JTextComponent)view.getContainer();
        ComponentState hostState = host.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        Color unselected = SubstanceCoreUtilities.getForegroundColor(host, hostState, hostState);
        g.setColor(unselected);
        Document doc = view.getDocument();
        Segment s = new Segment();
        doc.getText(p0, p1 - p0, s);
        int ret = TextUtilities.drawTabbedText(view, s, x, y, g, tabExpander, p0);
        return ret;
    }
}

